/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.controls.base.IFXLabelFloatControl;
import com.jfoenix.controls.base.IFXStaticControl;
import com.jfoenix.skins.JFXTextFieldSkin$$Lambda$1;
import com.jfoenix.skins.JFXTextFieldSkin$$Lambda$2;
import com.jfoenix.skins.JFXTextFieldSkin$$Lambda$3;
import com.jfoenix.skins.JFXTextFieldSkin$$Lambda$4;
import com.jfoenix.skins.JFXTextFieldSkin$$Lambda$5;
import com.jfoenix.skins.JFXTextFieldSkin$$Lambda$6;
import com.jfoenix.skins.PromptLinesWrapper;
import com.jfoenix.skins.ValidationPane;
import com.sun.javafx.scene.control.skin.TextFieldSkin;
import java.lang.reflect.Field;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;

public class JFXTextFieldSkin<T extends TextField>
extends TextFieldSkin {
    private boolean invalid = true;
    private Text promptText;
    private Pane textPane = (Pane)this.getChildren().get(0);
    private Node textNode;
    private DoubleProperty textTranslateX;
    private ValidationPane<T> errorContainer;
    private PromptLinesWrapper<T> linesWrapper;

    public JFXTextFieldSkin(T textField) {
        super(textField);
        this.reflectionFieldConsumer("textNode", JFXTextFieldSkin$$Lambda$1.lambdaFactory$(this));
        this.reflectionFieldConsumer("textTranslateX", JFXTextFieldSkin$$Lambda$2.lambdaFactory$(this));
        this.linesWrapper = new PromptLinesWrapper<T>(textField, (ObjectProperty<Paint>)this.promptTextFill, (ObservableValue<?>)textField.textProperty(), (ObservableValue<String>)textField.promptTextProperty(), JFXTextFieldSkin$$Lambda$3.lambdaFactory$(this));
        this.linesWrapper.init(JFXTextFieldSkin$$Lambda$4.lambdaFactory$(this), new Node[]{this.textPane});
        this.reflectionFieldConsumer("usePromptText", JFXTextFieldSkin$$Lambda$5.lambdaFactory$(this));
        this.errorContainer = new ValidationPane<T>(textField);
        this.getChildren().addAll((Object[])new Node[]{this.linesWrapper.line, this.linesWrapper.focusedLine, this.linesWrapper.promptContainer, this.errorContainer});
        this.registerChangeListener((ObservableValue)textField.disableProperty(), "DISABLE_NODE");
        this.registerChangeListener((ObservableValue)((IFXLabelFloatControl)textField).focusColorProperty(), "FOCUS_COLOR");
        this.registerChangeListener((ObservableValue)((IFXLabelFloatControl)textField).unFocusColorProperty(), "UNFOCUS_COLOR");
        this.registerChangeListener((ObservableValue)((IFXStaticControl)textField).disableAnimationProperty(), "DISABLE_ANIMATION");
    }

    protected void handleControlPropertyChanged(String propertyReference) {
        if ("DISABLE_NODE".equals(propertyReference)) {
            this.linesWrapper.updateDisabled();
        } else if ("FOCUS_COLOR".equals(propertyReference)) {
            this.linesWrapper.updateFocusColor();
        } else if ("UNFOCUS_COLOR".equals(propertyReference)) {
            this.linesWrapper.updateUnfocusColor();
        } else if ("DISABLE_ANIMATION".equals(propertyReference)) {
            this.errorContainer.updateClip();
        } else {
            super.handleControlPropertyChanged(propertyReference);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double height = ((TextField)this.getSkinnable()).getHeight();
        this.linesWrapper.layoutLines(x, y, w, h, height, Math.floor(h));
        this.errorContainer.layoutPane(x, height + this.linesWrapper.focusedLine.getHeight(), w, h);
        if (((TextField)this.getSkinnable()).getWidth() > 0.0) {
            this.updateTextPos();
        }
        this.linesWrapper.updateLabelFloatLayout();
        if (this.invalid) {
            this.invalid = false;
            this.errorContainer.invalid(w);
            this.linesWrapper.invalid();
        }
    }

    private void updateTextPos() {
        double textWidth = this.textNode.getLayoutBounds().getWidth();
        double promptWidth = this.promptText == null ? 0.0 : this.promptText.getLayoutBounds().getWidth();
        switch (this.getHAlignment()) {
            case CENTER: {
                this.linesWrapper.promptTextScale.setPivotX(promptWidth / 2.0);
                double midPoint = this.textRight.get() / 2.0;
                double newX = midPoint - textWidth / 2.0;
                if (!(newX + textWidth <= this.textRight.get())) break;
                this.textTranslateX.set(newX);
                break;
            }
            case LEFT: {
                this.linesWrapper.promptTextScale.setPivotX(0.0);
                break;
            }
            case RIGHT: {
                this.linesWrapper.promptTextScale.setPivotX(promptWidth);
            }
        }
    }

    private void createPromptNode() {
        if (this.promptText != null || !this.linesWrapper.usePromptText.get()) {
            return;
        }
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add((Object)"text");
        this.promptText.visibleProperty().bind((ObservableValue)this.linesWrapper.usePromptText);
        this.promptText.fontProperty().bind((ObservableValue)((TextField)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind((ObservableValue)((TextField)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind(this.linesWrapper.animatedPromptTextFill);
        this.promptText.setLayoutX(1.0);
        this.promptText.getTransforms().add((Object)this.linesWrapper.promptTextScale);
        this.linesWrapper.promptContainer.getChildren().add((Object)this.promptText);
        if (((TextField)this.getSkinnable()).isFocused() && ((IFXLabelFloatControl)this.getSkinnable()).isLabelFloat()) {
            this.promptText.setTranslateY(-Math.floor(this.textPane.getHeight()));
            this.linesWrapper.promptTextScale.setX(0.85);
            this.linesWrapper.promptTextScale.setY(0.85);
        }
        try {
            this.reflectionFieldConsumer("promptNode", JFXTextFieldSkin$$Lambda$6.lambdaFactory$(this));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <T> void reflectionFieldConsumer(String fieldName, CheckedConsumer<Field> consumer) {
        Field field = null;
        try {
            field = TextFieldSkin.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            consumer.accept(field);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ void lambda$createPromptNode$5(JFXTextFieldSkin this_, Field field) throws Exception {
        Object oldValue = field.get((Object)this_);
        if (oldValue != null) {
            this_.textPane.getChildren().remove(oldValue);
        }
        field.set((Object)this_, this_.promptText);
    }

    static /* synthetic */ void lambda$new$4(JFXTextFieldSkin this_, Field field) throws Exception {
        field.set((Object)this_, this_.linesWrapper.usePromptText);
    }

    static /* synthetic */ void lambda$new$3(JFXTextFieldSkin this_) {
        this_.createPromptNode();
    }

    static /* synthetic */ Text lambda$new$2(JFXTextFieldSkin this_) {
        return this_.promptText;
    }

    static /* synthetic */ void lambda$new$1(JFXTextFieldSkin this_, Field field) throws Exception {
        this_.textTranslateX = (DoubleProperty)field.get((Object)this_);
    }

    static /* synthetic */ void lambda$new$0(JFXTextFieldSkin this_, Field field) throws Exception {
        this_.textNode = (Node)field.get((Object)this_);
    }

    private static interface CheckedConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

